import java.math.BigInteger;

public class BerechnenMuehsam {        
        
    /**
     *  Berechnet das Schluesselwort durch Iteration, die Modulo einschliesst.
     *  Dauert bei grossen Zahlen sehr, sehr lange, kommt aber irgendwann mal zum Ziel.
     *  
     *  @param t Anzahl der Iterationen
     *  @param n der Modulo-Divisor
     *  @return 
     */
    static BigInteger berechnenMitModulo(BigInteger t, BigInteger n) {
        BigInteger ergebnis = new BigInteger("2");
        for (BigInteger big = BigInteger.valueOf(1);
        big.compareTo(t) <=0;
        big = big.add(BigInteger.ONE)) {
            System.out.print(ergebnis+"^2 = ");
            ergebnis = ergebnis.modPow(new BigInteger("2"),n);
            System.out.println(ergebnis + " (mod "+n+")");
        }
        System.out.println("\nErgebnis: w = "+ergebnis);
        return ergebnis;    
    }

    /**
     *  Berechnet das Schluesselwort durch Iteration, die Modulo-Division kommt erst ganz am Schluss.
     *  Stoesst relativ schnell an Speicherplatzgrenzen.
     *   
     *  @param t Anzahl der Iterationen
     *  @param n der Modulo-Divisor
     *  @return 
     */
    static BigInteger berechnenOhneModulo(BigInteger t, BigInteger n) {
        BigInteger ergebnis = new BigInteger("2");
        for (BigInteger big = BigInteger.valueOf(1);
        big.compareTo(t) <=0;
        big = big.add(BigInteger.ONE)) {
            System.out.print("2^2^"+(big.subtract(BigInteger.ONE))+" = "+ergebnis);
            System.out.println();
            ergebnis = ergebnis.pow(2);
        }
        ergebnis = ergebnis.mod(n);
        System.out.println("\nErgebnis: w = "+ergebnis);
        return ergebnis;    
    }
    

}
